package it.eng.eremita.jpa.entity;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import io.leangen.graphql.annotations.GraphQLQuery;

@Entity
@Table(name="EREMITA_METADATO_HABITAT")
@SequenceGenerator(name="SEQ_METADATO_HABITAT", sequenceName="SEQ_METADATO_HABITAT", initialValue=1, allocationSize=1)

public class MetadatoHabitat implements Serializable {
	
	Long id;
	MonitoraggioHabitat monitoraggioHabitat;
	Metadato metadato;
	String valore;
	
	
	@Id
	@GeneratedValue(strategy=GenerationType.SEQUENCE,generator="SEQ_METADATO_HABITAT")
	@Column(name="ID")
	@GraphQLQuery(name="id",description="Id oggetto, univoco.")
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	
	@ManyToOne
	@JoinColumn(name="ID_HABITAT")
	@GraphQLQuery(name="habitat",description="Il monitoraggio habitat di questo metadato")
	public MonitoraggioHabitat getMonitoraggioHabitat() {
		return monitoraggioHabitat;
	}

	public void setMonitoraggioHabitat(MonitoraggioHabitat monitoraggioHabitat) {
		this.monitoraggioHabitat = monitoraggioHabitat;
	}

	@ManyToOne
	@JoinColumn(name="ID_METADATO")
	@GraphQLQuery(name="metadato",description="Il metadato a cui si fa riferimento")
	public Metadato getMetadato() {
		return metadato;
	}

	public void setMetadato(Metadato metadato) {
		this.metadato = metadato;
	}

	@Column(name="VALORE",length=512)
	@GraphQLQuery(name="valore",description="Il valore del metadato per questo monitoraggio")
	public String getValore() {
		return valore;
	}

	public void setValore(String valore) {
		this.valore = valore;
	}
	
	public boolean equals(Object o) {
		if (o==null) return false;
		
		if (!(o instanceof MetadatoHabitat)) return false;
		
		MetadatoHabitat ms = (MetadatoHabitat)o;
		if (ms.getId()==this.getId()) return true;
		if (ms.getId()==null) return false;
		return (ms.getId().equals(this.getId()));

	}

}
